(function ($) {

    $(document).ready(function () {

        /**
         * Takeout url parameter values
         * @param {string} name (the parameter key)
         * @return string
         * */
        function get_url_parameters(name) {
            const url_params = new URLSearchParams(window.location.search);
            return url_params.get(name) || '';
        }


        /**
         * Print the content of a URL using an iframe
         * @param {string} url
         * @return void
         */
        function wooi_print_url(url) {
            if (!url) {
                console.error('URL is required for printing.');
                return;
            }

            // Create a hidden iframe
            const wooi_iframe = document.createElement('iframe');
            wooi_iframe.style.position = 'absolute';
            wooi_iframe.style.top = '-10000px'; // Hide the iframe off-screen
            wooi_iframe.style.left = '-10000px'; // Hide the iframe off-screen
            wooi_iframe.style.width = '0';
            wooi_iframe.style.height = '0';
            wooi_iframe.style.border = 'none';
            document.body.appendChild(wooi_iframe);

            // Load the URL into the iframe
            wooi_iframe.src = url;

            // Wait for the iframe to load
            wooi_iframe.onload = function () {
                try {
                    // Trigger print for the iframe
                    wooi_iframe.contentWindow.focus();
                    wooi_iframe.contentWindow.print();
                } catch (wooi_error) {
                    console.error('Error printing iframe content:', wooi_error);
                } finally {
                    // Clean up after printing
                    setTimeout(() => {
                        document.body.removeChild(wooi_iframe);
                    }, 1000); // Delay to allow print dialog to appear
                }
            };
        }


        /**
         * Reloads the iframe by resetting its url
         * @param {string} target (Element selector)
         * @return void
         * */
        function wooi_reload_iframe(target = '') {
            let iframe = $(target);
            if (!iframe.length) {
                return;
            }
            let url = iframe.attr('src');
            // In the first load, it loads the code_(header,body,footer)
            // In reloading the iframe, it becomes preview
            url += '&preview=true';
            // Set the src attribute to itself to reload the iframe
            iframe.attr('src', url);
        }


        /**
         * Pass partial data to backend with ajax post
         * the preview_update_meta is provided in class-posttype
         * Depends on wooi_reload_iframe
         * @return void
         * */
        function wooi_update_preview_ajax() {
            let wooi_update_preview_data = {
                action: 'preview_update_meta',
                post_ID: $('#post_ID').val(),
                code_body: wooi_code_mirror_body.getValue(),
                code_header: wooi_code_mirror_header.getValue(),
                code_footer: wooi_code_mirror_footer.getValue(),
                nonce: wooi_ajax_object.nonce
            };

            $.post(wooi_ajax_object.ajax_url, wooi_update_preview_data, function (response) {
                // If it's not successfully saved the post data, so only show error in console
                if (!response.success) {
                    console.error('خطا در ذخیره سازی اطلاعات : ' + response.data);
                    return;
                }
                wooi_reload_iframe('#preview_page_iframe');
            });
        }


       /**
        * Update city list based on province filter selection
        * */
        let wooi_province_filter = $("#province-filter");
        let wooi_city_filter = $("#city-filter");
        if (wooi_province_filter.length > 0) {
            wooi_province_filter.on('change', function () {
                var wooi_selected_province_code = $(this).find('option:selected').attr('data-state-code');
                // The city set if exists in "URL"
                var wooi_selected_city = get_url_parameters('city');
                // Ajax to set cities based on selected state
                $.ajax({
                    url: wooi_ajax_object.ajax_url,
                    method: 'POST',
                    data: {
                        action: 'wooi_get_cities',
                        province: wooi_selected_province_code,
                        city: wooi_selected_city,
                        nonce: wooi_ajax_object.nonce,
                    },
                    success: function (response) {
                        if (response.success) {
                            // Update the city select dropdown with the new options
                            wooi_city_filter.html(response.data.options);
                        } else {
                            // Handle the error
                            console.error('Error fetching cities:', response.data.message);
                            wooi_city_filter.html('<option value="" disabled selected>لطفا استان را انتخاب کنید</option>');
                        }
                    },
                    error: function (error) {
                        console.error('AJAX error:', error);
                        wooi_city_filter.html('<option value="" disabled selected>خطا در لیست شهر ها</option>');
                    }
                });

            });

            wooi_province_filter.trigger('change');
        }

        /**
         * Printing button action
         * */
        var wooi_direct_print_button = $(".wooi_print_directly")
        if (wooi_direct_print_button.length > 0) {
            wooi_direct_print_button.on('click', function (e) {
                var wooi_page_url = $(this).data('action-link');
                if (wooi_page_url) {
                    wooi_print_url(wooi_page_url);
                }
            });
        }

        /**
         * Control pre-invoice panel options
         * */
        var wooi_pre_invoice_enable_checkbox = $("[id*=wooi_pre_invoice\\[enable\\]]");
        var wooi_pre_invoice_page_id = $("[id*=wooi_pre_invoice\\[page_id\\]]");
        var wooi_pre_invoice_page_id_options = $("[id*=wooi_pre_invoice\\[page_id\\]] option");
        var wooi_pre_invoice_button_text = $("[id*=wooi_pre_invoice\\[button_text\\]]");
        var wooi_pre_invoice_button_hook = $("[id*=wooi_pre_invoice\\[button_hook\\]]");

        /**
         * Show and hide options based on enabling pre invoice
         * */
        wooi_pre_invoice_enable_checkbox.on('change', function () {
            if (!$(this).prop('checked')) {
                wooi_pre_invoice_page_id.closest('tr').hide()
                wooi_pre_invoice_button_text.closest('tr').hide()
                wooi_pre_invoice_button_hook.closest('tr').hide()
            } else {
                wooi_pre_invoice_page_id.closest('tr').show()
                wooi_pre_invoice_button_text.closest('tr').show()
                wooi_pre_invoice_button_hook.closest('tr').show()
            }
        });
        wooi_pre_invoice_enable_checkbox.trigger('change');

        /**
         *
         * Provides preview for wooi posttype in admin area
         * It'll update partials of the post to view them live
         *
         * */
        if ('undefined' != typeof wooi_code_mirror_header && 'undefined' != typeof wooi_code_mirror_body && 'undefined' != typeof wooi_code_mirror_footer) {
            // Store the initial values for later check ( got changed or not )
            var wooi_initial_code_mirror_header = wooi_code_mirror_header.getValue();
            var wooi_initial_code_mirror_body = wooi_code_mirror_body.getValue();
            var wooi_initial_code_mirror_footer = wooi_code_mirror_footer.getValue();
            // Partial update the post whenever each code mirror section has changed and blured
            wooi_code_mirror_body.on('blur', function (e) {
                let wooi_current_code_mirror_body = wooi_code_mirror_body.getValue()
                if (wooi_initial_code_mirror_body === wooi_current_code_mirror_body) {
                    return;
                }
                wooi_update_preview_ajax()
            });
            wooi_code_mirror_header.on('blur', function (e) {
                let wooi_current_code_mirror_header = wooi_code_mirror_header.getValue()
                if (wooi_initial_code_mirror_header === wooi_current_code_mirror_header) {
                    return;
                }
                wooi_update_preview_ajax()
            });
            wooi_code_mirror_footer.on('blur', function (e) {
                let wooi_current_code_mirror_footer = wooi_code_mirror_footer.getValue()
                if (wooi_initial_code_mirror_footer === wooi_current_code_mirror_footer) {
                    return;
                }
                wooi_update_preview_ajax()
            });
        }

    });

})(jQuery);